/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.util;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.AbstractInput;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.RadioInput;
import de.willuhn.jameica.gui.util.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class Container {
    private boolean fullSize = false;

    public Container(boolean fullSize) {
        this.fullSize = fullSize;
    }

    public abstract Composite getComposite();

    protected final boolean isFullSize() {
        return this.fullSize;
    }

    public void addLabelPair(String name, Input input) {
        int style;
        int align = Customizing.SETTINGS.getBoolean("application.view.labels.alignleft", false) ? 32 : 128;
        GridData labelGrid = new GridData(align);
        labelGrid.verticalAlignment = 2;
        if (input instanceof AbstractInput && ((style = ((AbstractInput)input).getStyleBits()) & 0x710) == 1808) {
            labelGrid.verticalAlignment = 1;
        }
        Label label = GUI.getStyleFactory().createLabel(this.getComposite(), 0);
        label.setText(name != null ? name : "");
        if (input.isMandatory() && Application.getConfig().getMandatoryLabel()) {
            label.setForeground(Color.ERROR.getSWTColor());
        }
        label.setLayoutData((Object)labelGrid);
        input.paint(this.getComposite());
        input.setData("jameica.label", label);
    }

    public void addInput(Input input) {
        if (input instanceof CheckboxInput || input instanceof RadioInput) {
            this.addCheckable(input, input.getName());
        } else {
            this.addLabelPair(input.getName(), input);
        }
    }

    public void addLabelPair(Input left, Input right) {
        left.paint(this.getComposite(), 50);
        right.paint(this.getComposite());
    }

    public void addCheckbox(CheckboxInput checkbox, String text) {
        this.addCheckable(checkbox, text);
    }

    public void addRadioInput(RadioInput radio, String text) {
        this.addCheckable(radio, text);
    }

    private void addCheckable(Input checkable, String text) {
        if (text != null && checkable.getName() == null) {
            checkable.setName(text);
        }
        GridData labelGrid = new GridData(768);
        labelGrid.horizontalSpan = 2;
        Composite comp = new Composite(this.getComposite(), 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)labelGrid);
        checkable.paint(comp, 40);
    }

    public void addText(String text, boolean linewrap) {
        this.addText(text, linewrap, null);
    }

    public void addText(String text, boolean linewrap, Color color) {
        GridData labelGrid = new GridData(768);
        labelGrid.horizontalSpan = 2;
        final Label label = GUI.getStyleFactory().createLabel(this.getComposite(), linewrap ? 64 : 0);
        if (color != null) {
            label.setForeground(color.getSWTColor());
        }
        label.setText(text);
        label.setLayoutData((Object)labelGrid);
        if (linewrap) {
            label.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    label.setSize(label.computeSize(label.getSize().x, -1));
                }
            });
        }
    }

    public void addPart(Part part) {
        try {
            GridData grid = new GridData(this.isFullSize() ? 1808 : 768);
            grid.horizontalSpan = 2;
            Composite comp = new Composite(this.getComposite(), 0);
            comp.setLayoutData((Object)grid);
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            comp.setLayout((Layout)layout);
            part.paint(comp);
        }
        catch (RemoteException e) {
            Logger.error((String)"error while adding part", (Throwable)e);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Anzeigen des Dialogs."), 1));
        }
    }

    public void addHeadline(String text) {
        GridData grid = new GridData(768);
        grid.horizontalSpan = 2;
        grid.horizontalIndent = 0;
        Composite comp = new Composite(this.getComposite(), 0);
        comp.setLayoutData((Object)grid);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 3;
        layout.marginWidth = 2;
        comp.setLayout((Layout)layout);
        Label label = GUI.getStyleFactory().createLabel(comp, 0);
        label.setFont(Font.H2.getSWTFont());
        label.setText(text);
        label.setLayoutData((Object)new GridData(32));
        Label line = GUI.getStyleFactory().createLabel(comp, 258);
        line.setLayoutData((Object)new GridData(768));
    }

    public void addSeparator() {
        GridData lineGrid = new GridData(768);
        lineGrid.horizontalSpan = 2;
        Label line = GUI.getStyleFactory().createLabel(this.getComposite(), 258);
        line.setLayoutData((Object)lineGrid);
    }

    public ButtonArea createButtonArea(int numButtons) {
        this.addSeparator();
        GridData g = new GridData(896);
        g.horizontalSpan = 2;
        Composite comp = new Composite(this.getComposite(), 0);
        comp.setLayoutData((Object)g);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        comp.setLayout((Layout)gl);
        return new ButtonArea(comp, numButtons);
    }

    public void addButtonArea(de.willuhn.jameica.gui.parts.ButtonArea buttonArea) {
        try {
            this.addSeparator();
            GridData g = new GridData(896);
            g.horizontalSpan = 2;
            Composite comp = new Composite(this.getComposite(), 0);
            comp.setLayoutData((Object)g);
            GridLayout gl = new GridLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            comp.setLayout((Layout)gl);
            buttonArea.paint(comp);
        }
        catch (RemoteException e) {
            Logger.error((String)"error while adding button area", (Throwable)e);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Anzeigen des Buttons."), 1));
        }
    }
}

